/**
 * @file   zaurss.h
 * @author NOKUBI Takatsugu
 * @date   Wed Dec 17 13:37:25 2003
 * 
 * @brief  header file for ZauRSS main window
 * 
 * $Id: zaurss.h 125 2004-03-11 05:10:02Z knok $
 */

#ifndef ZAURSS_H
#define ZAURSS_H

#include <qmainwindow.h>
#include <qcstring.h>
#include <qtable.h>
#include <qcolor.h>

class ZRConf;
class HttpGet;

class QFrame;
class QHBoxLayout;
class QVBoxLayout;
class QTable;
class QTextBrowser;
class QNetworkOperation;
class QUrlOperator;
class ZRss;
class QPEMenuBar;

class QTableF;
class QTableI;
class QKeyEvent;

class ZauRSS : public QMainWindow
{
  Q_OBJECT ;
 public:
  ZauRSS(QWidget *parent = 0, const char *name = 0, int wFlags = 0);
  ~ZauRSS();

  void updateRssview();

  bool readRss(QString &url, QString &enc);
  bool updateTable();
  void cleanTable();
  void mergeItems(int);

 public slots:
   void exitapp();
 void updaterss();
 // XXX disabled
 // void getrss();
 void doubleClicked(int, int, int, const QPoint&);
 void selectFeed(int, int, int, const QPoint&);
 void addrss();
 void editrsstitle();
 void editrssurl();
 void delrss();
 void getStart();
 void getFinished();
 void helpdialog();
 void focustoother(QTableI *);

 enum HtgetState {
     None = 0,
     Update,
     AddRss,
 };

 private:
  QPEMenuBar *menuBar;

  QFrame *topF;
  QHBoxLayout *topL;
  QFrame *rightF;
  QVBoxLayout *rightL;
  QTableI *feeds;
  QTableI *items;
  QTextBrowser *text;

  // for http fetching
  int httpmode;
  HttpGet *ht;
  int updatedPos;
  HtgetState hts;

  // for RSS
  ZRss *rss;
  ZRConf *rconf;
  bool seeNewRss;
  int currentRssPos;
};

class QTableI : public QTable {
Q_OBJECT;
public:
 QTableI(int r, int c, QWidget *p = 0, const char *n = 0)
   : QTable(r, c, p, n) {
   setFocusPolicy(QWidget::StrongFocus);
   orig = palette().active().button();
   unfocus = QColor(orig.red() - 50, orig.green() - 50, orig.blue() - 50);
 };
 void chcolor();

signals:
    void changeFocus(QTableI *);
protected:
    void keyPressEvent(QKeyEvent *);
    QColor orig, unfocus;
};

#endif
