/**
 * @file   zaurss.cpp
 * @author NOKUBI Takatsugu
 * @date   Wed Dec 17 13:50:38 2003
 * 
 * @brief  ZauRSS main window class
 * 
 * $Id: zaurss.cpp 125 2004-03-11 05:10:02Z knok $
 */

#include "zaurss.h"
#include "version.h"
#include "sax/zrss.h"

#include <qpe/qcopenvelope_qws.h>

#include <qframe.h>
#include <qlayout.h>
#include <qtable.h>
#include <qtextbrowser.h>
#include <qaction.h>
#include <qpetoolbar.h>
#include <qpemenubar.h>
#include <qcstring.h>
#include <qurloperator.h>
#include <qstring.h>
#include <qnetworkprotocol.h>
#include <qmessagebox.h>

#include "zrurldialogimpl.h"
#include "qinputdialog.h"
#include "dom/zrconf.h"

#include "httpget.h"	// use QHttp
#include "qhttp.h"
#include <stdlib.h>
#include <string.h>

ZauRSS::ZauRSS(QWidget *parent = 0, const char *name = 0, int wFlags = 0)
  : QMainWindow(parent, name, wFlags)
{
  // initialize
  httpmode = 0;
  updatedPos = -1;
  ht = NULL;
  hts = None;
  rss = NULL;
  rconf = new ZRConf;
  seeNewRss = false;
  currentRssPos = 0;

  setName("ZauRSS");
  setCaption(tr("ZauRSS"));
  setToolBarsMovable(FALSE);

  QPEToolBar *toolBar = new QPEToolBar(this, "tool");
  toolBar->setHorizontalStretchable(TRUE);
  addToolBar(toolBar, "tool", QMainWindow::Top, TRUE);
  menuBar = new QPEMenuBar(toolBar);
  QPopupMenu *listMenuFile = new QPopupMenu(menuBar);
  menuBar->insertItem(tr("File"), listMenuFile);
  this->setFont(QFont("lcfont", 16, QFont::Normal));
  QAction *actUpdate = new QAction("Update RSS", QString::null, 0, this, 0);
  connect(actUpdate, SIGNAL(activated()), this, SLOT(updaterss()));
  actUpdate->addTo(listMenuFile);
#if 0 // Disabled
  QAction *actEnterrss = new QAction("Enter RSS", QString::null, 0, this, 0);
  connect(actEnterrss, SIGNAL(activated()), this, SLOT(getrss()));
  actEnterrss->addTo(listMenuFile);
#endif 
  QAction *actAddrss = new QAction("Add RSS", QString::null, 0, this, 0);
  connect(actAddrss, SIGNAL(activated()), this, SLOT(addrss()));
  actAddrss->addTo(listMenuFile);
  QAction *actEditrsst = new QAction("Edit RSS title", QString::null, 0, this, 0);
  connect(actEditrsst, SIGNAL(activated()), this, SLOT(editrsstitle()));
  actEditrsst->addTo(listMenuFile);
  QAction *actEditrssu = new QAction("Edit RSS url", QString::null, 0, this, 0);
  connect(actEditrssu, SIGNAL(activated()), this, SLOT(editrssurl()));
  actEditrssu->addTo(listMenuFile);
  QAction *actDelrss = new QAction("Delete RSS", QString::null, 0, this, 0);
  connect(actDelrss, SIGNAL(activated()), this, SLOT(delrss()));
  actDelrss->addTo(listMenuFile);
  QAction *actExit = new QAction("Exit", QString::null, 0, this, 0);
  connect(actExit, SIGNAL(activated()), this, SLOT(exitapp()));
  actExit->addTo(listMenuFile);
  QPopupMenu *listMenuHelp = new QPopupMenu(menuBar);
  menuBar->insertItem(tr("Help"), listMenuHelp);
  QAction *actAbout = new QAction("About", QString::null, 0, this, 0);
  connect(actAbout, SIGNAL(activated()), this, SLOT(helpdialog()));
  actAbout->addTo(listMenuHelp);

  topF = new QFrame(this);
  setCentralWidget(topF);
  topL = new QHBoxLayout(topF);
  topL->setSpacing(1);
  topL->setMargin(1);                    

  feeds = new QTableI(0, 1, topF);
  feeds->setColumnMovingEnabled(false);
  feeds->setRowMovingEnabled(false);
  feeds->setFont(QFont("lcfont", 16, QFont::Normal));
  feeds->setLeftMargin(0); // hide horizontal header
  feeds->horizontalHeader()->setLabel(0, "RDF");
  connect(feeds, SIGNAL(doubleClicked(int, int, int, const QPoint&)),
	  this, SLOT(selectFeed(int, int, int, const QPoint&)));
  connect(feeds, SIGNAL(changeFocus(QTableI *)), 
	  this, SLOT(focustoother(QTableI *)));
  topL->addWidget(feeds);

  rightF = new QFrame(topF);
  topL->addWidget(rightF);
  rightL = new QVBoxLayout(rightF);
  items = new QTableI(0, 2, rightF);
  rightL->addWidget(items);
  text = new QTextBrowser(rightF);
  rightL->addWidget(text);

  items->setColumnMovingEnabled(false);
  items->setRowMovingEnabled(false);
  items->setFont(QFont("lcfont", 16, QFont::Normal));
  items->setLeftMargin(0); // hide virtical header
  items->horizontalHeader()->setLabel(0, "");
  items->horizontalHeader()->setLabel(1, tr("Title"));
  items->setColumnWidth(0, 32);

  connect(items, SIGNAL(doubleClicked(int, int, int, const QPoint&)),
	  this, SLOT(doubleClicked(int, int, int, const QPoint&)));
  connect(items, SIGNAL(changeFocus(QTableI *)), 
	  this, SLOT(focustoother(QTableI *)));

  updateRssview();
  feeds->setFocus();
  feeds->chcolor();
  items->chcolor();
}

ZauRSS::~ZauRSS()
{
  delete rconf;
  if (rss) delete rss;
}

void ZauRSS::updateRssview()
{
  feeds->setNumRows(rconf->rss.size());
  for (int i = 0; i < rconf->rss.size(); i ++) {
    QTableItem *vi = new QTableItem(feeds, QTableItem::Never,
				    rconf->rss.at(i)->title);
    feeds->setItem(i, 0, vi);
  }
  feeds->adjustColumn(0);
}

void ZauRSS::exitapp()
{
  close();
}

void ZauRSS::updaterss()
{
  if (ht != NULL && ht->status() != HttpGet::Null)
      return;
  updatedPos = feeds->currentRow();
  QString url = rconf->rss.at(updatedPos)->link;
  hts = Update;
  readRss(url, rconf->rss.at(updatedPos)->encoding);
}

void ZauRSS::addrss()
{
    QString url, enc;
    bool ok = FALSE;
    ok = ZRUrlDialogImpl::getUrlEnc(url, enc);
    if (ok && !url.isEmpty()) {
	hts = AddRss;
	readRss(url, enc);
    }
}

bool ZauRSS::readRss(QString &url, QString &enc)
{
  if (ht != NULL)
      delete ht;
  qDebug("encoding: %s\n", (const char *)enc);
  ht = new HttpGet(url, "ZauRss/" VERSION, enc);
  connect(ht, SIGNAL(getstart()), this, SLOT(getStart()));
  connect(ht, SIGNAL(getfinished()), this, SLOT(getFinished()));
  ht->get(); // get async
  return true;
}

bool ZauRSS::updateTable()
{
    items->setNumRows(rss->getItems().size());
    for (int i = 0; i < rss->getItems().size(); i ++) {
	QTableItem *opt;
	if (rss->getItems().at(i)->seen) {
	  opt = new QTableItem(items, QTableItem::Never, "x");
	} else {
	  opt = new QTableItem(items, QTableItem::Never, "o");
	}
	QTableItem *text = new QTableItem(items, QTableItem::Never,
					  rss->getItems().at(i)->title);
	items->setItem(i, 0, opt);
	items->setItem(i, 1, text);
    }
    items->adjustColumn(1);
    items->setCurrentCell(0, 0);
    rconf->save();
    return true;
}

void ZauRSS::doubleClicked(int row, int, int, const QPoint&)
{
    if (row < 0) return;
    // send qcop message to open a URL
    QCopEnvelope e("QPE/Application/netfront3", "setDocument(QString)");
    if (seeNewRss) {
      e << rss->getItems().at(row)->link;
      text->setText(QString("open:\n%1").arg(rss->getItems().at(row)->link));
      rss->getItems().at(row)->seen = true;
    } else {
      e << rconf->rss.at(currentRssPos)->items.at(row)->link;
      text->setText(QString("open:\n%1").
		    arg(rconf->rss.at(currentRssPos)->items.at(row)->link));
      rconf->rss.at(currentRssPos)->items.at(row)->seen = true;
    }
    QTableItem *opt = new QTableItem(items, QTableItem::Never, "x");
    items->setItem(row, 0, opt);
    rconf->save();
    items->setFocus();
    feeds->chcolor();
    items->chcolor();
}

void ZauRSS::selectFeed(int row, int, int, const QPoint&)
{
  if (row < 0) return;
  seeNewRss = false;
  currentRssPos = row;
  ZRConfRss *r = rconf->rss.at(currentRssPos);
  items->setNumRows(r->items.size());
  for (int i = 0; i < r->items.size(); i ++) {
    if (r->items.at(i)->seen) {
      QTableItem *opt = new QTableItem(items, QTableItem::Never, "x");
      items->setItem(i, 0, opt);
    } else {
      QTableItem *opt = new QTableItem(items, QTableItem::Never, "o");
      items->setItem(i, 0, opt);
    }
    QTableItem *text = new QTableItem(items, QTableItem::Never,
				      r->items.at(i)->title);
    items->setItem(i, 1, text);
  }
  items->adjustColumn(1);
  items->setCurrentCell(0, 0);
  QString cap("ZauRSS: %1");
  setCaption(cap.arg(r->title));
  feeds->setFocus();
  feeds->chcolor();
  items->chcolor();
}

#if 0 // XXX disabled
void ZauRSS::getrss()
{
    QString url, enc;
    bool ok = FALSE;
    url = QInputDialog::getText(tr("RDF URL"), tr("Enter URL"),
				QString::null, &ok, this);
    if (ok && !url.isEmpty()) {
	text->setText("starting update");
	if (readRss(url) == false) {
	    text->setText("readRss failure.");
	} else {
	    seeNewRss = true;
	    text->setText(QString("updated.\nit has %1 items.")
			  .arg(rss->getItems().size()));
	    updateTable();
	}
    }
}
#endif

void ZauRSS::editrsstitle()
{
  int row = feeds->currentRow();
  QString title(rconf->rss.at(row)->title);
  bool ok = FALSE;
  QString title2 = QInputDialog::getText(tr("Edit RDF title"), 
					 tr("Enter title"),
					 title, &ok, this);
  if (ok && !title2.isEmpty() && title != title2) {
    rconf->rss.at(row)->title = title2;
    QTableItem *vi = new QTableItem(feeds, QTableItem::Never,
				    title2);
    feeds->setItem(row, 0, vi);
    feeds->adjustColumn(0);
  }
}

void ZauRSS::editrssurl()
{
  int row = feeds->currentRow();
  QString url(rconf->rss.at(row)->link);
  bool ok = FALSE;
  QString url2 = QInputDialog::getText(tr("Edit RDF URL"), 
                                        tr("Enter URL"),
                                        url, &ok, this);
  if (ok && !url2.isEmpty() && url != url2) {
    rconf->rss.at(row)->link = url2;
    for (int i = 0; i < rconf->rss.at(row)->items.size(); i ++) {
      delete rconf->rss.at(row)->items.at(i);
    }
    rconf->rss.at(row)->items.resize(0);
    cleanTable();
  }
}

void ZauRSS::delrss()
{
  int row = feeds->currentRow();
  switch (QMessageBox::warning(this, "Delete?", 
			      QString("Do You wan to delete\n%1 ?").
			      arg(rconf->rss.at(row)->link), 
			      QMessageBox::Ok, QMessageBox::Cancel)) {
  case QMessageBox::Ok:
    delete rconf->rss.at(row);
    rconf->rss.remove(row);
    for (int i = row + 1; i < rconf->rss.size(); i ++) {
      rconf->rss.insert(i - 1, rconf->rss.at(i));
    }
    rconf->rss.resize(rconf->rss.size() - 1);
    updateRssview();
  case QMessageBox::Cancel:
  default:
    break;
  }
}

void ZauRSS::cleanTable()
{
  items->setNumRows(0);
}

void ZauRSS::mergeItems(int pos)
{
  QVector<ZRConfRssItem> *ri = &(rconf->rss.at(pos)->items);
  for (int i = 0; i < rss->getItems().size(); i ++) {
    // check same item on rconf
    int npos = -1; // find same item
    for (int j = 0; j < ri->size(); j ++) {
      if (ri->at(j)->link == rss->getItems().at(i)->link) {
	npos = j;
	break;
      }
    }
    if (npos >= 0) { // if find same item, then set seen flag
      rss->getItems().at(i)->seen = ri->at(npos)->seen;
    }
  }
}

void ZauRSS::getStart()
{
  text->setText("starting update");
}

void ZauRSS::getFinished()
{
    int pos = updatedPos;
    seeNewRss = false;
    if (rss != NULL)
	delete rss;
    if (ht->statusCode() != 200) {
      if (ht->status() == HttpGet::Timeout) {
	QMessageBox::critical(this, "ZauRSS", 
			      "Connection Timeout.");
      } else {
	QMessageBox::critical(this, "ZauRSS", 
			      QString("Update Failed.\nStatus: %1").
			      arg(ht->statusCode()));
      }
      delete ht;
      ht = NULL;
      hts = None;
      return;
    }
    rss = new ZRss(ht->contents(), ht->encoding);
    text->setText(QString("updated.\nit has %1 items.")
		  .arg(rss->getItems().size()));
    if (hts == Update) {
	mergeItems(pos);
	QVector<ZRConfRssItem> *items = &(rconf->rss.at(pos)->items);
	items->resize(rss->getItems().size());
	for (int i = 0; i < rss->getItems().size(); i ++) {
	    ZRConfRssItem *r = new ZRConfRssItem;
	    r->title = rss->getItems().at(i)->title;
	    r->link = rss->getItems().at(i)->link;
	    r->seen = rss->getItems().at(i)->seen;
	    items->insert(i, r);
	}
	updateTable();
	this->items->adjustColumn(1);
	QString cap("ZauRSS: %1");
	setCaption(cap.arg(rconf->rss.at(pos)->title));
    } else if (hts == AddRss) {
	ZRConfRss *nr = new ZRConfRss;
	nr->id = rconf->rss.size();
	nr->title = rss->getName();
	nr->link = ht->getUrl();
	nr->encoding = rss->getEncoding();
	nr->items.resize(rss->getItems().size());
	for (int i = 0; i < rss->getItems().size(); i ++) {
	    ZRConfRssItem *r = new ZRConfRssItem;
	    r->title = rss->getItems().at(i)->title;
	    r->link = rss->getItems().at(i)->link;
	    r->seen = rss->getItems().at(i)->seen;
	    nr->items.insert(i, r);
	}
	rconf->rss.resize(rconf->rss.size() + 1);
	rconf->rss.insert(rconf->rss.size() - 1, nr);
	updateRssview();
    }
    delete ht;
    ht = NULL;
    hts = None;
}

void ZauRSS::helpdialog()
{
    QMessageBox::information(this, "ZauRSS",
			     "ZauRSS Version. " VERSION "\n"
			     "Copyright (c) 2003-2004\n"
			     "NOKUBI Takatsugu\n"
			     "This software is released \n"
			     "under GNU GPL.\n"
	);
}

void ZauRSS::focustoother(QTableI *t)
{
    if (t == feeds) {
      if (items->numRows() > 0)
	    items->setFocus();
    } else {
	feeds->setFocus();
    }
  feeds->chcolor();
  items->chcolor();
}

void QTableI::keyPressEvent(QKeyEvent *e)
{
    switch (e->key()) {
    case Key_Space:
    case Key_Return:
	emit doubleClicked(currentRow(), currentColumn(), 0, QPoint());
	return;
    case Key_Left:
	if (currentColumn() == 0)
	    emit changeFocus(this);
	break;
    case Key_Right:
	if (currentColumn() +1 >= numCols())
	    emit changeFocus(this);
	break;
    }
    QTable::keyPressEvent(e);
}

void QTableI::chcolor()
{
  QPalette p = palette();
  if (hasFocus()) {
    p.setColor(QColorGroup::Button, orig);
  } else {
    p.setColor(QColorGroup::Button, unfocus);
  }
  setPalette(p);
}
