/**
 * @file   zrss.h
 * @author NOKUBI Takatsugu
 * @date   Fri Dec 19 14:18:14 2003
 * 
 * @brief  header file for RSS parser class
 * 
 * $Id: zrss.h 115 2004-02-15 05:27:41Z knok $
 */

#ifndef ZRSS_H
#define ZRSS_H

#include <qxml.h>
#include <qvector.h>
#include <qbuffer.h>

class QString;
class QXmlDefaultHandler;

class ZRssItem {
 public:
  QString title;
  QString link;
  bool seen;
};

class ZRssHandler : public QXmlDefaultHandler {
 public:
  ZRssHandler();
  ~ZRssHandler();
  bool startDocument();
  bool startElement(const QString &, const QString &, const QString &,
		    const QXmlAttributes &);
  bool endElement(const QString &, const QString &, const QString &);
  bool characters(const QString &);

  const QString &getName();
  const QString &getLink();
  const QString &getDesc();

  QVector<ZRssItem> items;

  enum Mode {
    None = 0,
    Channel = 1,
    Item = 2,
    Title = 0x10,
    ChannelTitle = 0x11,
    ItemTitle = 0x12,
    Link = 0x20,
    ChannelLink = 0x21,
    ItemLink = 0x22,
  };

 private:
  QString chName;
  QString chLink;
  QString chDesc;

  Mode mode;
  ZRssItem *citem;
};

class ZRss {
 public:
  ZRss(QString &, QString enc = QString::null);
  ZRss();
  ~ZRss();
  const QString &getName();
  const QString &getLink();
  const QString &getDesc();
  const QString &getEncoding();
  QVector<ZRssItem> &getItems();

 private:
  ZRssHandler *zh;
  QString encoding;
};

class ZRssError : public QXmlErrorHandler {
 public:
  bool warning(const QXmlParseException &);
  bool error(const QXmlParseException &);
  bool fatalError(const QXmlParseException &);
  QString errorString();
 private:
  QString err;
};

#endif /* ZRSS_H */
