/**
 * @file   httpget.h
 * @author NOKUBI Takatsugu
 * @date   Fri Dec 26 14:54:34 2003
 * 
 * @brief  http get class
 * 
 * $Id$
 */

#ifndef HTTPGET_H_
#define HTTPGET_H_

#include <qobject.h>
#include <qbuffer.h>

class QUrl;
class QHttp;
class QHttpResponseHeader;
class QBuffer;
class QString;
class QTimer;

#define HTTPGET_DEFAULT_TIMEOUT (180 * 1000)

class HttpGet : public QObject
{
  Q_OBJECT;

 public:

  enum Status {
    Null = 0,
    InProgress,
    Finished,
    Timeout,
  };

  HttpGet(const QString &, const QString & = 0, const QString & = 0);
  ~HttpGet();
  void get(int = HTTPGET_DEFAULT_TIMEOUT);
  Status status();
  QString &contents();
  QString &getUrl();
  int statusCode();

  QString encoding;

 public slots:
  void recvdone(bool);
 void response(const QHttpResponseHeader &);
 void timeout();

 signals:
  void getstart();
  void getfinished();

 private:
  QUrl *url;
  QHttp *http;
  QBuffer buf;
  QString cont;
  Status stat;
  QString strurl;
  int respcode;
  QString useragent;
  QTimer *timer;
};

#endif
