/**
 * @file   httpget.cpp
 * @author NOKUBI Takatsugu
 * @date   Fri Dec 26 15:03:58 2003
 * 
 * @brief  http get class
 * 
 * $Id$
 */

#include "httpget.h"
#include "qhttp.h"
#include <qurloperator.h>
#include <qnetwork.h>
#include <qurl.h>
#include <qbuffer.h>
#include <qiodevice.h>
#include <qtimer.h>
#include <qtextcodec.h>

HttpGet::HttpGet(const QString &u, const QString &ua, const QString &enc)
{
  url = new QUrl(u);
  http = new QHttp();
  timer = NULL;
  encoding = enc;
  int port = url->port();
  if (port < 0) port = 80;
  http->setHost(url->host(), port);
  qDebug("host: %s, port %d", (const char *)url->host(), port);
  cont.truncate(0);
  stat = Null;
  strurl = u;
  respcode = 0;
  if (ua == 0) {
    useragent = "httpget/0.1";
  } else {
    useragent = ua;
  }
  connect(http, SIGNAL(responseHeaderReceived(const QHttpResponseHeader&)),
	  this, SLOT(response(const QHttpResponseHeader&)));
}

HttpGet::~HttpGet()
{
  delete url;
  delete http;
  cont.truncate(0);
  if (timer != NULL)
    delete timer;
}

void HttpGet::get(int tm)
{
  qDebug("get");
  connect(http, SIGNAL(done(bool)),
	  this, SLOT(recvdone(bool)));
  QHttpRequestHeader header("GET", url->encodedPathAndQuery());
  header.setValue("Connection", "Keep-Alive");
  header.setValue("Host", url->host());
  header.setValue("User-Agent", useragent);
  http->request(header, (QIODevice *) 0, &buf);
  qDebug("path: %s", (const char *)url->encodedPathAndQuery());
  stat = InProgress;
  timer = new QTimer;
  connect(timer, SIGNAL(timeout()), this, SLOT(timeout()));
  timer->start(tm, TRUE);
  emit getstart();
}

HttpGet::Status HttpGet::status()
{
  return stat;
}

QString& HttpGet::contents()
{
  return cont;
}

void HttpGet::recvdone(bool s)
{
    qDebug("finished: %d", s);
  stat = Finished;
  disconnect(timer, 0, this, 0);
  delete timer;
  timer = NULL;
  if (!s) {
      if (encoding == "euc-jp") {
	  QTextCodec *codec = QTextCodec::codecForName("eucJP");
	  cont = codec->toUnicode(buf.buffer());
      } else if (encoding == "sjis") {
	  QTextCodec *codec = QTextCodec::codecForName("Shift-JIS");
	  cont = codec->toUnicode(buf.buffer());
      } else if (encoding == "jis") {
	  QTextCodec *codec = QTextCodec::codecForName("JIS7");
	  cont = codec->toUnicode(buf.buffer());
      } else {			// utf-8 (default)
	  cont = QString::fromUtf8(buf.buffer());
      }
  } else {
      qDebug("false: %s", (const char *)http->errorString());
  }
  emit getfinished();
}

QString &HttpGet::getUrl()
{
    return strurl;
}

void HttpGet::response(const QHttpResponseHeader &resp)
{
  respcode = resp.statusCode();
}

int HttpGet::statusCode()
{
  return respcode;
}

void HttpGet::timeout()
{
  if (stat == Finished)
    return;
  qDebug("connection timeout");
  stat = Timeout;
  disconnect(http, SIGNAL(done(bool)), this, SLOT(recvdone(bool)));
  emit getfinished();
}
