/**
 * @file   zrconf.cpp
 * @author NOKUBI Takatsugu
 * @date   Wed Dec 24 10:32:38 2003
 * 
 * @brief  ZauRSS configuration class
 * 
 * 
 */

#include "../version.h"
#include "zrconf.h"
#include "qdom.h"
#include <qpe/global.h>
#include <qfile.h>
#include <qtextstream.h>

#include <unistd.h>

ZRConfRss::ZRConfRss()
{
}

ZRConfRss::~ZRConfRss()
{
  for (int i = 0; i < items.size(); i ++)
    delete items[i];
}

ZRConf::ZRConf()
{
  load();
}

ZRConf::~ZRConf()
{
  save();
  for (int i = 0; i < rss.size(); i ++)
    delete rss[i];
}

bool ZRConf::load()
{
  QString fname;
  fname = Global::applicationFileName("ZauRSS", "zaurss.xml");
  QFile f(fname);
  if (f.open(IO_ReadOnly)) {
    QDomDocument dom("zaurss");
    if (!dom.setContent(&f))
      return false;
    f.close();
    QDomElement root = dom.documentElement();
    QDomNode ver = root.namedItem("version");
    if (ver.isNull()) { // has no version
      version = DATAVERSION;
    } else {
      version = ver.toElement().text();
    }
    // get rss info
    QDomNode nrssinfo = root.namedItem("rssinfo");
    if (nrssinfo.isNull()) return false;
    QDomElement rssinfo = nrssinfo.toElement();
    QDomNodeList lrss = rssinfo.elementsByTagName("rss");
    for (int i = 0; i < lrss.length(); i ++) {
      QDomElement erss = lrss.item(i).toElement();
      rss.resize(rss.size() + 1);
      ZRConfRss *r = new ZRConfRss;
      rss.insert(rss.size() - 1, r);
      r->id = erss.namedItem("id").toElement().text().toInt();
      r->title = erss.namedItem("title").toElement().text();
      r->link = erss.namedItem("link").toElement().text();
      if (version == "1.0") {
	  r->encoding = "utf-8"; // new info in 1.1
      } else {
	  r->encoding = erss.namedItem("encoding").toElement().text();
      }
      QDomNodeList litems = erss.elementsByTagName("item");
      for (int j = 0; j < litems.length(); j ++) {
	QDomElement eitem = litems.item(j).toElement();
	ZRConfRssItem *item = new ZRConfRssItem;
	rss[i]->items.resize(rss[i]->items.size() + 1);
	rss[i]->items.insert(rss[i]->items.size() - 1, item);
	item->title = eitem.namedItem("title").toElement().text();
	item->link = eitem.namedItem("link").toElement().text();
	item->seen = false;
	if (eitem.namedItem("seen").toElement().text() == "true")
	  item->seen = true;
      }
    }
  } else {
    version = "1.0";
    rss.resize(1);
    ZRConfRss *r = new ZRConfRss;

    r->title = QString::fromLatin1((const char *)"mu antenna");
    r->link = QString::fromLatin1((const char *)"http://ukai.org/mu/mu.rdf");
    r->encoding = "utf-8";
    r->id = 1;
    rss.insert(0, r);
    //rss.at(0).items.resize(0);
  }
  return true;
}

bool ZRConf::save()
{
  QDomDocument dom("zaurss");
  QDomElement root = dom.createElement("zaurss");
  dom.appendChild(root);
  QDomElement ver = dom.createElement("version");
  root.appendChild(ver);
  QDomText verval = dom.createTextNode(DATAVERSION);
  ver.appendChild(verval);
  QDomElement rssinfo = dom.createElement("rssinfo");
  root.appendChild(rssinfo);
  for (int i = 0; i < rss.size(); i ++) {
    QDomElement drss = dom.createElement("rss");
    rssinfo.appendChild(drss);
    QDomElement id = dom.createElement("id");
    drss.appendChild(id);
    QDomText vid = dom.createTextNode(QString("%1").arg(rss[i]->id));
    id.appendChild(vid);
    QDomElement title = dom.createElement("title");
    drss.appendChild(title);
    QDomText vtitle = dom.createTextNode(rss[i]->title);
    title.appendChild(vtitle);
    QDomElement link = dom.createElement("link");
    drss.appendChild(link);
    QDomText vlink = dom.createTextNode(rss[i]->link);
    link.appendChild(vlink);
    QDomElement enc = dom.createElement("encoding");
    drss.appendChild(enc);
    QDomText venc = dom.createTextNode(rss[i]->encoding);
    enc.appendChild(venc);
    QVector<ZRConfRssItem> items = rss[i]->items;
    for (int j = 0; j < items.size(); j ++) {
      QDomElement item = dom.createElement("item");
      drss.appendChild(item);
      QDomElement ntitle = dom.createElement("title");
      item.appendChild(ntitle);
      QDomText nvtitle = dom.createTextNode(items[j]->title);
      ntitle.appendChild(nvtitle);
      QDomElement nlink = dom.createElement("link");
      item.appendChild(nlink);
      QDomText nvlink = dom.createTextNode(items[j]->link);
      nlink.appendChild(nvlink);
      QDomElement seen = dom.createElement("seen");
      item.appendChild(seen);
      QDomText vseen = dom.createTextNode("false");
      if (items[j]->seen)
	vseen.setData("true");
      seen.appendChild(vseen);
    }
  }
  QString fnamen = Global::applicationFileName("ZauRSS", "zaurss.xml.new");
  QString fnameo = Global::applicationFileName("ZauRSS", "zaurss.xml");
  QFile f(fnamen);
  if (f.open(IO_WriteOnly)) {
    QTextStream stream(&f);
    stream.setEncoding(QTextStream::UnicodeUTF8);
    stream << dom.toString();
    f.close();
    unlink(fnameo);
    rename(fnamen, fnameo);
  }
}
