/**
 * @file   zrurldialogimpl.cpp
 * @author NOKUBI Takatsugu
 * @date   Sun Feb 15 11:41:02 2004
 * 
 * @brief  UI Implementation
 * 
 * 
 */

#include "zrurldialogimpl.h"
#include <qapplication.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>

ZRUrlDialogImpl::ZRUrlDialogImpl(QWidget * parent, const char * name, bool m, WFlags f)
    : ZRUrlDialog(parent, name, m, f)
{
    EncodingBox->insertItem("utf-8");
    EncodingBox->insertItem("euc-jp");
    EncodingBox->insertItem("sjis");
    EncodingBox->insertItem("jis");

    connect(URLEdit, SIGNAL(returnPressed()), this, SLOT(tryAccept()));
    connect(OkButton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));

    resize( QMAX( sizeHint().width(), QApplication::desktop()->width() ),
	    sizeHint().height() );
}

bool ZRUrlDialogImpl::getUrlEnc(QString &url, QString &enc)
{
    ZRUrlDialogImpl *dlg = new ZRUrlDialogImpl(NULL, NULL, TRUE, 0);
    dlg->URLEdit->selectAll();
    bool ok_ = FALSE;
    ok_ = dlg->exec() == QDialog::Accepted;
    if (ok_) {
	url = dlg->URLEdit->text();
	enc = dlg->EncodingBox->currentText();
    }
    delete dlg;
    return ok_;
}

void ZRUrlDialogImpl::tryAccept()
{
    if (!URLEdit->text().isEmpty())
	accept();
}
